#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(30196);
 script_cve_id("CVE-2007-5794");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: nss_ldap security update (nss_ldap-4773)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch nss_ldap-4773.

Description :

nss_ldap returned incorrect data under certain
circumstances to the calling process. Some applications
could therefore work with wrong user data (CVE-2007-5794).


Solution : 

Install the security patch nss_ldap-4773.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the nss_ldap-4773 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"nss_ldap-246-14.20", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nss_ldap-32bit-246-14.20", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nss_ldap-64bit-246-14.20", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nss_ldap-253-19.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nss_ldap-32bit-253-19.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nss_ldap-64bit-253-19.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
