#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27362);
 script_cve_id("CVE-2007-3099", "CVE-2007-3100");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: open-iscsi: This update fixes a possible DoS attack on the iSCSI daemon. (open-iscsi-4034)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch open-iscsi-4034.

Description :

This update fixes insecure privileges and credential
verification with the iscsi daemon. (CVE-2007-3099,
CVE-2007-3100)


Solution : 

Install the security patch open-iscsi-4034.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the open-iscsi-4034 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"open-iscsi-2.0.713-13", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
