#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27364);
 script_cve_id("CVE-2006-5779");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: OpenLDAP security update (openldap2-client-2282)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch openldap2-client-2282.

Description :

OpenLDAP libldap's strval2strlen() function contained a bug
when processing the authcid string of certain Bind
Requests, which could allow attackers to  cause an affected
application (especially the OpenLDAP Server) to crash
(CVE-2006-5779).


Solution : 

Install the security patch openldap2-client-2282.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the openldap2-client-2282 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"openldap2-client-2.3.19-18.11", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openldap2-client-32bit-2.3.19-18.11", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openldap2-client-64bit-2.3.19-18.11", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
