#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29542);
 script_cve_id("CVE-2006-2937", "CVE-2006-4343");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for OpenSSL (openssl-2141)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch openssl-2141.

Description :

A buffer overflow condition within the
SSL_get_shared_ciphers() function and a DoS condition known
as 'parasitic public keys' have been fixed. The later
problem allowed attackers to trick the OpenSSL engine to
spend an extraordinary amount of time to process public
keys. The following CAN numbers have been assigned:
CVE-2006-2937, CVE-2006-2940, CVE-2006-3738 and
CVE-2006-4343.



Solution : 

Install the security patch openssl-2141.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the openssl-2141 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"openssl-0.9.8a-18.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openssl-devel-0.9.8a-18.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openssl-0.9.8a-18.10", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openssl-devel-0.9.8a-18.10", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
