#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29544);
 script_cve_id("CVE-2007-5135");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for OpenSSL (openssl-4477)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch openssl-4477.

Description :

This update of openssl fixes a off-by-one buffer overflow
in function SSL_get_shared_ciphers(). This vulnerability
potentially allows remote code execution; depending on
memory layout of the process. (CVE-2007-5135)


Solution : 

Install the security patch openssl-4477.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the openssl-4477 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"openssl-0.9.8a-18.18", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openssl-devel-0.9.8a-18.18", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openssl-doc-0.9.8a-18.18", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openssl-0.9.8a-18.18", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openssl-devel-0.9.8a-18.18", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
