#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27372);
 script_cve_id("CVE-2006-3198");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: opera: Security update to version 9.0 (opera-1697)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch opera-1697.

Description :

The webbrowser Opera has been upgraded to version 9.0 to
add lots of new features, and to fix the following security
problem:

CVE-2006-3198: An integer overflow vulnerability exists in
the Opera Web Browser due to the improper handling of JPEG
files.

If excessively large height and width values are specified
in certain fields of a JPEG file, an integer overflow may
cause Opera to allocate insufficient memory for the image.
This will lead to a buffer overflow when the image is
loaded into memory, which can be exploited to execute
arbitrary code.


Solution : 

Install the security patch opera-1697.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the opera-1697 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"opera-9.0-1.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
