#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27375);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: opera: Securityupgrade to version 9.10. (opera-2456)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch opera-2456.

Description :

This update brings the Opera Webbrowser to version 9.10,
fixing following 2 security problems:

- Opera processes a JPEG DHT marker incorrectly, which can
  potentially lead to remote code execution.

- Opera is affected by a typecasting bug in its Javascripts
  SVG implementation which could potentially be used to
  execute code.


Solution : 

Install the security patch opera-2456.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the opera-2456 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"opera-9.10-3.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"opera-9.10-3.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
