#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27380);
 script_cve_id("CVE-2007-0003");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: pam security update (pam-2601)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch pam-2601.

Description :

A bug in pam_unix module allowed users under certain
circumstances to log in although their account was locked.
pam_unix is not used on openSUSE by default though
(CVE-2007-0003).


Solution : 

Install the security patch pam-2601.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the pam-2601 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"pam-0.99.6.3-29.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"pam-32bit-0.99.6.3-29.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"pam-64bit-0.99.6.3-29.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
