#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27387);
 script_cve_id("CVE-2007-3377", "CVE-2007-3409");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: perl-Net-DNS: security update (perl-Net-DNS-3961)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch perl-Net-DNS-3961.

Description :

perl-Net-DNS used sequential IDs for DNS lookups which
could cause problem with some programs like spamassassin.
It potentially also simplified DNS spoofing attacks against
perl-Net-DNS (CVE-2007-3377).

Additionally malformed compressed DNS packets could trigger
an endless loop in perl-Net-DNS (CVE-2007-3409).


Solution : 

Install the security patch perl-Net-DNS-3961.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the perl-Net-DNS-3961 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"perl-Net-DNS-0.55-12.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-Net-DNS-0.59-18", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
