#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31340);
 script_cve_id("CVE-2006-4484");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: perl-Tk security update (perl-Tk-5035)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch perl-Tk-5035.

Description :

Specially crafted GIF files could crash perl-Tk
(CVE-2006-4484).


Solution : 

Install the security patch perl-Tk-5035.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the perl-Tk-5035 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"perl-Tk-804.027-15.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-Tk-804.027-33", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-Tk-804.027-95.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
