#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27393);
 script_cve_id("CVE-2006-2417", "CVE-2006-2418");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: phpMyAdmin security update (phpMyAdmin-1581)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch phpMyAdmin-1581.

Description :

Missing checks of the 'db' and 'theme' parameters could be 
exploited for cross site scripting attacks (CVE-2006-2417, 
CVE-2006-2418).


Solution : 

Install the security patch phpMyAdmin-1581.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the phpMyAdmin-1581 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"phpMyAdmin-2.8.0.3-10.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
