#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27399);
 script_cve_id("CVE-2007-3387");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: poppler security update (poppler-3991)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch poppler-3991.

Description :

A buffer overflow in the xpdf code contained in poppler
could be exploited by attackers to potentially execute
arbitrary code (CVE-2007-3387).


Solution : 

Install the security patch poppler-3991.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the poppler-3991 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"poppler-0.4.4-19.12", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"poppler-devel-0.4.4-19.12", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"poppler-0.5.4-33.3", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"poppler-devel-0.5.4-33.3", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
