#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27402);
 script_cve_id("CVE-2006-2313", "CVE-2006-2314");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: postgresql security update (postgresql-server-1442)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch postgresql-server-1442.

Description :

This update fixes a security problem that allowed attackers 
to inject SQL commands into queries (CVE-2006-2313, 
CVE-2006-2314).


Solution : 

Install the security patch postgresql-server-1442.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the postgresql-server-1442 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"postgresql-server-patch-message-1-1442-1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"postgresql-server-8.1.4-1.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"postgresql-server-patch-message-2-1442-1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
