#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29566);
 script_cve_id("CVE-2007-4137");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for qt3 (qt3-4420)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch qt3-4420.

Description :

This update fixes a buffer overflow in qt3 while handling
UTF8 characters. (CVE-2007-4137)


Solution : 

Install the security patch qt3-4420.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the qt3-4420 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"qt3-3.3.5-58.32", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-3.3.5-58.32", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-doc-3.3.5-58.29", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-tools-3.3.5-58.29", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-3.3.5-58.32", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-3.3.5-58.32", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-doc-3.3.5-58.29", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-tools-3.3.5-58.29", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
