#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29789);
 script_cve_id("CVE-2007-6199", "CVE-2007-6200");

 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: rsync: fix to deny bypassing of module hierarchy (rsync-4793)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch rsync-4793.

Description :

This update fixes a bug in rsync that allowed remote
attackers to access restricted files outside a module's
hierarchy if no chroot setup was used. (CVE-2007-6199)
Please read http://rsync.samba.org/security.html entry from
November 28th, 2007 to get more information about a secure
configuration of rsync that also covers the bug tracked
with CVE-2007-6200.  This update also fixes some crashes
that only affect rsync-2.6.8 on SLES10.


Solution : 

Install the security patch rsync-4793.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the rsync-4793 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"rsync-2.6.8-36.22", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"rsync-2.6.8-31", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"rsync-2.6.9-55.4", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
