#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29573);
 script_cve_id("CVE-2007-5162");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for ruby (ruby-4702)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ruby-4702.

Description :

This update of ruby improves the SSL certificate
verification process. (CVE-2007-5162, CVE-2007-5770)  Prior
to this update it was possible to intercept SSL traffic
with a man-in-the-middle attack.


Solution : 

Install the security patch ruby-4702.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ruby-4702 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ruby-1.8.4-17.16", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
