#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(28371);
 script_cve_id("CVE-2007-5380");

 script_version ("$Revision: 1.3 $");

 name["english"] = "SuSE Security Update: rubygem-actionpack security update (rubygem-actionpack-4754)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch rubygem-actionpack-4754.

Description :

Malicious users could specify their session-ID in the URL
and could gain access to an authenticated session that way
(CVE-2007-5380).


Solution : 

Install the security patch rubygem-actionpack-4754.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the rubygem-actionpack-4754 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"rubygem-actionpack-1.12.5-19", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"rubygem-actionpack-1.13.3-20.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
