#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27433);
 script_cve_id("CVE-2006-4573");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: screen: Security problem in UTF-8 combining (screen-2198)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch screen-2198.

Description :

A special formed UTF-8 sequence in text could be used to
crash the terminal multitasker screen by overwriting memory
in the heap. This is potentially exploitable to execute
code. (CVE-2006-4573)


Solution : 

Install the security patch screen-2198.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the screen-2198 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"screen-4.0.2-62.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
