#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29579);
 script_cve_id("CVE-2006-4434");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for sendmail (sendmail-2030)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch sendmail-2030.

Description :

Without this update sendmail may crash when finishing a
mail due to referencing an already freed variable
(CVE-2006-4434).


Solution : 

Install the security patch sendmail-2030.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the sendmail-2030 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"sendmail-8.13.6-9.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"sendmail-8.13.6-9.9", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
