#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27447);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: smb4k: This update fixes several security bugs in smb4k. (smb4k-2514)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch smb4k-2514.

Description :

This update of smb4k fixes several security bugs that can
be exploited locally to get access to confidential data,
overwrite file contents, and to overflow process memory.


Solution : 

Install the security patch smb4k-2514.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the smb4k-2514 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"smb4k-0.7.5-14.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
