#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27450);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: spamassassin: Versionsupdate to version 3.1.7 (spamassassin-2523)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch spamassassin-2523.

Description :

Primary it is a version update for the packages
spamassassin und perl-spamassasin to version 3.1.7.

Furthermore the following bugs were fixed: 

- SpamAssassin URIDNSBL plugin tries to lookup libraries
  (libimf.so,
 liblua.so, ...) via nameserver
- BUG in archive PgSQL.pm (SpamAssassin)


Solution : 

Install the security patch spamassassin-2523.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the spamassassin-2523 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"perl-spamassassin-3.1.7-6.2.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.7-6.2.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-spamassassin-3.1.7-6.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.7-6.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
