#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29582);
 script_cve_id("CVE-2007-0247", "CVE-2007-0248");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for squid (squid-2502)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch squid-2502.

Description :

This update fixes a remotely exploitable denial-of-service
bug in squid, that can be triggered by using special ftp://
URLs. (CVE-2007-0247)
 The packages are not vulnerable to a
bug in external ACLs. (CVE-2007-0248)


Solution : 

Install the security patch squid-2502.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the squid-2502 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"squid-2.5.STABLE12-18.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"squid-2.5.STABLE12-18.6", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
