#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27457);
 script_cve_id("CVE-2007-1262", "CVE-2007-2589");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: squirrelmail: fix two cross site scripting bugs (squirrelmail-3629)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch squirrelmail-3629.

Description :

This update of squirrelmail fixes two cross-site-scripting
vulnerabilities that can be used by an attacker to read
opened emails (CVE-2007-1262) and to send email on behalf
of the user (CVE-2007-2589).


Solution : 

Install the security patch squirrelmail-3629.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the squirrelmail-3629 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"squirrelmail-1.4.5-18.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"squirrelmail-1.4.9a-2.5", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
