#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27460);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: sylpheed-claws: Update to align with clamav 0.90.x (sylpheed-claws-2685)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch sylpheed-claws-2685.

Description :

The mailreader sylpheed-claws directly links to the clamav
virus scan engine.

Since we released clamav 0.90 which contains a library so
version change we need to release this package to align the
requirements.


Solution : 

Install the security patch sylpheed-claws-2685.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the sylpheed-claws-2685 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"sylpheed-claws-1.0.3-26.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"sylpheed-claws-2.5.5-27", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
