#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27461);
 script_cve_id("CVE-2007-2958");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: sylpheed-claws: This update fixes a format string bug. (sylpheed-claws-4511)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch sylpheed-claws-4511.

Description :

This update fixes a format string bug in the
inc_put_error() function. This bug is triggered when error
messages from the POP3 server are displayed and can be
exploited remotely to execute arbitrary code.
(CVE-2007-2958)


Solution : 

Install the security patch sylpheed-claws-4511.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the sylpheed-claws-4511 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"sylpheed-claws-1.0.3-26.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"sylpheed-claws-2.5.5-29", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
