#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27467);
 script_cve_id("CVE-2006-4810");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: texinfo: Fixed security problem in texinfo file processing (texinfo-2264)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch texinfo-2264.

Description :

Specially crafted texinfo files could crash texinfo
utilities. (CVE-2006-4810)


Solution : 

Install the security patch texinfo-2264.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the texinfo-2264 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"texinfo-4.8-22.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
