#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27514);
 script_cve_id("CVE-2007-5191");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: util-linux security update (util-linux-4552)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch util-linux-4552.

Description :

Insufficient length checks when reading the passphrase for
encrypted paritions in the mount program could cause a
buffer overflow that could potentially be exploited to gain
root privileges.

When executing helper program 'mount' didn't check the
return value of setuid(). Therefore helper program could
potenially run as root (CVE-2007-5191).


Solution : 

Install the security patch util-linux-4552.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the util-linux-4552 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"util-linux-2.12r+2.13rc2+git20070725-24.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
