#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27480);
 script_cve_id("CVE-2006-2197");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: wv2: Securityfix for missing boundary checks (wv2-1687)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch wv2-1687.

Description :

The wv2 library was updated to fix some boundary checks 
which could be exploited by maliciously crafted files to 
access memory outside bounds and possibly execute arbitrary 
code. (CVE-2006-2197)


Solution : 

Install the security patch wv2-1687.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the wv2-1687 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"wv2-0.2.2-21.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"wv2-devel-0.2.2-21.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
