#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23780);
  script_version ("$Revision: 1.4 $");

  script_cve_id("CVE-2006-6221");
  script_bugtraq_id(21300);

  script_name(english:"ThinClientServer Admin Account Creation Vulnerability");
  script_summary(english:"Tries to create an account in ThinClientServer");
 
  desc = "
Synopsis : 

The remote web server contains a PHP script that allows creation of
additional administrative accounts. 

Description :

The remote host is running ThinClientServer, an application to convert
existing PCs into thin clients. 

The version of ThinClientServer installed on the remote host allows an
unauthenticated remote attacker to create administrative accounts. 

See also : 

http://www.symantec.com/content/en/us/enterprise/research/SYMSA-2006-012.txt
http://www.securityfocus.com/advisories/11589

Solution :

It is reported that upgrading to ThinClientServer version 4.0.2248 or
higher addresses this issue.  You should also review the list of
existing administrators and remove any that are not valid. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 943, 980);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");


port = get_http_port(default:980);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Check whether the script exists.
url = "/enter.php?goto=%2F";
req = http_get(item:url, port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# If ..
if (
  # the script does exist and...
  "<title>2X - Login" >< res &&
  # we can't ostensibly create an account.
  "name='dologin_new'" >!< res
)
{
  # Try to exploit the flaw to generate another administrative user.
  user = string("nessus-", rand_str());
  pass = rand();
  pass2 = string("not", pass);         # so we don't actually create the account.
  postdata = string(
    "username=", user, "&",
    "password=", pass, "&",
    "re_password=", pass2, "&",
    "dologin_new=OK&",
    "dologin=true"
  );
  req = string(
    "POST ", url, " HTTP/1.1\r\n",
    "Host: ", get_host_name(), "\r\n",
    "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
    "Content-Type: application/x-www-form-urlencoded\r\n",
    "Content-Length: ", strlen(postdata), "\r\n",
    "\r\n",
    postdata
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we get an error about passwords not matching.
  #
  # nb: in 4.0.2324, we just get "Bad Username or Password".
  if ("Passwords don&#039;t match" >< res) security_hole(port);
}
