#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25525);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-2449");
  script_bugtraq_id(24476);

  script_name(english:"Tomcat snoop.jsp Cross-Site Scripting Vulnerability");
  script_summary(english:"Checks for an XSS flaw in Tomcat's snoop.jsp");

  desc = "
Synopsis :

The remote web server contains a JSP application that is vulnerable to
a cross-site scripting attack. 

Description :

The remote web server includes an example JSP application,
'snoop.jsp', that fails to sanitize user-supplied input before using
it to generate dynamic content.  An unauthenticated remote attacker
may be able to leverage this issue to inject arbitrary HTML or script
code into a user's browser to be executed within the security context
of the affected site. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2007-06/0183.html

Solution :

Undeploy the Tomcat examples web application. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 8080);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_kb_item("Services/www");
if (!port) port = 8080;
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# Unless we're paranoid, make sure the banner looks like Tomcat.
if (report_paranoia < 2)
{
  banner = get_http_banner(port:port);
  if (!banner || "Server: Apache-Coyote" >!< banner) exit(0);
}


# Send a request to exploit the flaw.
xss = raw_string("<script>alert('", SCRIPT_NAME, "')</script>");
exploit = string(";", xss, "test.jsp");
foreach dir (make_list("/examples/jsp", "/jsp-examples"))
{
  if ("/examples/jsp" == dir)
  {
    req = http_get(item:string(dir, "/snp/snoop.jsp"), port:port);
    req = ereg_replace(
      string:req,
      pattern:"^(.+)Host:[^" + '\r\n' + "]+(.+)",
      replace:"\1Host: " + xss + "\2"
    );
  }
  else
  {
    req = http_get(
      item:string(dir, "/snp/snoop.jsp", exploit), 
      port:port  
    );
  }
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if our exploit appears in the request URI.
  if (
    ("/examples/jsp" == dir && string("Server name: ", xss) >< res) ||
    (string("Request URI: /jsp-examples/snp/snoop.jsp", exploit) >< res)
  ) 
  {
    security_warning(port);
    exit(0);
  }
}
