#
# (C) Tenable Network Security
#

  desc["english"] = "
Synopsis :

It is possible to execute code on the remote host through the AntiVirus
Agent.

Description :

The remote version of Trend Micro ServerProtect is vulnerable to
multiple stack overflows in the RPC interface.  By sending specially
crafted requests to the remote host, an attacker may be able to
exploit stack based overflows and execute arbitrary code on the remote
host. 

See also : 

http://www.tippingpoint.com/security/advisories/TSRT-07-01.html
http://www.tippingpoint.com/security/advisories/TSRT-07-02.html

Solution :

Trend Micro has released a patch for ServerProtect for Windows/Netware:

http://www.trendmicro.com/download/product.asp?productid=17

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

  
if (description) 
{
 script_id(24680);
 script_cve_id("CVE-2007-1070");
 script_bugtraq_id(22639);
 script_version("$Revision: 1.3 $");

 script_name(english:"Trend Micro ServerProtect Multiple Stack Buffer Overflow Vulnerabilities");
 script_description(english:desc["english"]);
 
 script_summary(english:"Checks for ServerProtect version");
 
 script_category(ACT_GATHER_INFO);
 script_family(english:"Gain root remotely");

 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 script_require_ports(5168);
 script_dependencies ("trendmicro_serverprotect_detect.nasl");
 script_require_keys ("Antivirus/TrendMicro/ServerProtect");
 exit(0);
}

version = get_kb_item ("Antivirus/TrendMicro/ServerProtect");

if (!version)
  exit (0);

port = 5168;

v = split (version, sep:".", keep:FALSE);

if ( (v[0] < 5) ||
     (v[0] == 5 && v[1] < 58) ||
     (v[0] == 5 && v[1] == 58 && v[2] == 0 && v[3] < 1171) )
  security_hole(port:port);
