#
#  (C) 2007 Tenable Network Security
#

desc = "
Synopsis :

The remote Windows host is vulnerable to a buffer overflow
vulnerability. 

Description :

The remote host is running Trend Antivirus, a commercial anti-virus
software package for Windows.  The scan engine of the remote antivirus
is vulnerable to a UPX file parsing flaw which could potentially allow
an attacker to crash the scan engine or execute arbitrary code. 

Solution:

Upgrade virus pattern file to 4.245.00 or higher.

See also :

http://www.nessus.org/u?ddf2ff5c
http://www.kb.cert.org/vuls/id/276432
http://www.nessus.org/u?3bbc4482

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";

if (description) {
  script_id(24681);
  script_bugtraq_id(22449);
  script_xref(name:"OSVDB", value:"33038");
  script_cve_id("CVE-2007-0851");
  script_version("$Revision: 1.5 $");

  script_name(english:"Trend Micro UPX file parsing flaw detection");
  script_summary(english:"Checks if Trend Micro Antivirus virus pattern file is vulnerable"); 
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("trendmicro_installed.nasl");
  script_require_keys("Antivirus/TrendMicro/trendmicro_internal_pattern_version");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");

pattern_ver = get_kb_item("Antivirus/TrendMicro/trendmicro_internal_pattern_version");
good_pattern_ver = 424500;

# - check if virus pattern file is vulnerable?

trouble = 0;
if (!isnull(pattern_ver))
{
    if ( int(pattern_ver) < int(good_pattern_ver))
    {
      info += 'The virus pattern file ' + pattern_ver + ' on the remote host is vulnerable to the above flaw,' +
              ' please upgrade to ' + good_pattern_ver + ' or higher.\n';
      trouble++;
    }
}

if (trouble)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    info
  );
  security_hole(port:port, data:report);
}
