#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote Windows host is prone to a denial of service attack. 

Description :

The version of Trend Micro AntiVirus installed on the remote Windows
host contains a divide-by-zero error in its 'VsapiNT.sys' kernel
driver.  Using a specially-crafted UPX file, a remote attacker may be
able to leverage this flaw to crash the affected host. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=488
http://www.securityfocus.com/archive/1/462798/30/0/threaded
http://esupport.trendmicro.com/support/viewxml.do?ContentID=EN-1034587

Solution :

Update the Virus Pattern File to 4.335.00 or later. 

Risk factor : 

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:C)";


if (description)
{
  script_id(24815);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1591");
  script_bugtraq_id(22965);

  script_name(english:"Trend Micro UPX File Parsing Denial of Service Vulnerability");
  script_summary(english:"Checks version of virus pattern file");
 
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("trendmicro_installed.nasl");
  script_require_keys("Antivirus/TrendMicro/trendmicro_internal_pattern_version");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");

pats = get_kb_item("Antivirus/TrendMicro/trendmicro_internal_pattern_version");
if (!isnull(pats) && int(pats) < 433500)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus has determined that the current Virus Pattern File on the remote\n",
    "host is version ", pats, ".\n"
  );
  security_hole(port:get_kb_item("SMB/transport"), data:report);
}
