#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25148);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-2418");
  script_bugtraq_id(23781);

  script_name(english:"Trillian < 3.1.5.1 XMPP Decoding Heap Overflow Vulnerability");
  script_summary(english:"Checks version number of Trillian");

  desc = "
Synopsis :

The remote host contains an instant messaging application which is susceptible
to a heap overflow vulnerability.


Description :

The version of Trillian installed on the remote host contains a buffer
overflow vulnerability which can be triggered when decoding a malformed
XMPP (eXtensible Messaging and Presence Protocol) message. 

To exploit this flaw, an attacker would need to send a specially crafted
XMPP message to a user of this program, thus causing arbitrary code 
execution.


See also :

http://dvlabs.tippingpoint.com/advisory/TPTI-07-06

Solution :

Upgrade to Trillian 3.1.5.1 or later. 

Risk factor :

High / CVSS Base Score : 7.6
(CVSS2#AV:N/AC:H/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("trillian_installed.nasl");
  script_require_keys("SMB/Trillian/Version");

  exit(0);
}


ver = get_kb_item("SMB/Trillian/Version");
# Trillian > 3.1 is affected
if (ver && ver =~ "^3\.1\.([0-4]\.|5\.0)" )
  security_hole(get_kb_item("SMB/transport"));
