#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25547);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3305");
  script_bugtraq_id(24523);

  script_name(english:"Trillian < 3.1.6.0 Multiple Vulnerabilities");
  script_summary(english:"Checks version number of Trillian");

  desc = "
Synopsis :

The remote host contains an instant messaging application that is
affected by a buffer overflow vulnerability. 

Description :

The version of Trillian installed on the remote host reportedly is
affected by a heap buffer overflow issue involving improper handling
of UTF-8 sequences when word-wrapping UTF-8 text.  A remote attacker
may be able to leverage these issues to execute arbitrary code as the
current user. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=545
http://www.securityfocus.com/archive/1/471673/30/0/threaded
http://blog.ceruleanstudios.com/?p=150

Solution :

Upgrade to Trillian 3.1.6.0 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("trillian_installed.nasl");
  script_require_keys("SMB/Trillian/Version");

  exit(0);
}


ver = get_kb_item("SMB/Trillian/Version");
if (ver && ver =~ "^([0-2]\.|3\.(0\.|1\.[0-5]\.))")
  security_hole(get_kb_item("SMB/transport"));
