# This script was automatically generated from the 290-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "awstats" is missing a security patch.

Description :

Hendrik Weimer discovered a privilege escalation vulnerability in
awstats. By supplying the \'configdir\' CGI parameter and setting it to
an attacker-controlled directory (such as an FTP account, /tmp, or
similar), an attacker could execute arbitrary shell commands with the
privileges of the web server (user \'www-data\').

This update disables the \'configdir\' parameter by default. If all
local user accounts can be trusted, it can be reenabled by running
awstats with the AWSTATS_ENABLE_CONFIG_DIR environment variable set to
a nonempty value.

Solution :

Upgrade to : 
- awstats-6.5-1ubuntu1.1 (Ubuntu 6.06)



Risk factor : High
';

if (description) {
script_id(27862);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "290-1");
script_summary(english:"awstats vulnerability");
script_name(english:"USN290-1 : awstats vulnerability");
script_cve_id("CVE-2006-2644");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "awstats", pkgver: "6.5-1ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package awstats-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to awstats-6.5-1ubuntu1.1
');
}

if (w) { security_hole(port: 0, data: desc); }
