# This script was automatically generated from the 299-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "dhcdbd" is missing a security patch.

Description :

Florian Hackenberger discovered a memory corruption bug in dhcdbd (the
NetworkManager daemon for processing DHCP operations). Invalid DHCP
responses crashed dhcdbd, which caused NetworkManager to not work any
more.

Solution :

Upgrade to : 
- dhcdbd-1.10-0ubuntu11.1 (Ubuntu 6.06)



Risk factor : High
';

if (description) {
script_id(27874);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "299-1");
script_summary(english:"dhcdbd vulnerability");
script_name(english:"USN299-1 : dhcdbd vulnerability");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "dhcdbd", pkgver: "1.10-0ubuntu11.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dhcdbd-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to dhcdbd-1.10-0ubuntu11.1
');
}

if (w) { security_hole(port: 0, data: desc); }
