# This script was automatically generated from the 320-2 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libapache2-mod-php4 
- php4 
- php4-cgi 
- php4-cli 
- php4-common 
- php4-dev 


Description :

USN-320-2 fixed several vulnerabilities in PHP. James Manning
discovered that the Ubuntu 5.04 update introduced a regression, the
function tempnam() caused a crash of the PHP interpreter in some
circumstances. The updated packages fix this.

We apologize for the inconvenience.

Solution :

Upgrade to : 
- libapache2-mod-php4-4.3.10-10ubuntu4.6 (Ubuntu 5.04)
- php4-4.3.10-10ubuntu4.6 (Ubuntu 5.04)
- php4-cgi-4.3.10-10ubuntu4.6 (Ubuntu 5.04)
- php4-cli-4.3.10-10ubuntu4.6 (Ubuntu 5.04)
- php4-common-4.3.10-10ubuntu4.6 (Ubuntu 5.04)
- php4-dev-4.3.10-10ubuntu4.6 (Ubuntu 5.04)



Risk factor : High
';

if (description) {
script_id(27898);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "320-2");
script_summary(english:"php4 regression");
script_name(english:"USN320-2 : php4 regression");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "5.04", pkgname: "libapache2-mod-php4", pkgver: "4.3.10-10ubuntu4.6");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libapache2-mod-php4-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libapache2-mod-php4-4.3.10-10ubuntu4.6
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4", pkgver: "4.3.10-10ubuntu4.6");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-4.3.10-10ubuntu4.6
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4-cgi", pkgver: "4.3.10-10ubuntu4.6");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-cgi-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-cgi-4.3.10-10ubuntu4.6
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4-cli", pkgver: "4.3.10-10ubuntu4.6");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-cli-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-cli-4.3.10-10ubuntu4.6
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4-common", pkgver: "4.3.10-10ubuntu4.6");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-common-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-common-4.3.10-10ubuntu4.6
');
}
found = ubuntu_check(osver: "5.04", pkgname: "php4-dev", pkgver: "4.3.10-10ubuntu4.6");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package php4-dev-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to php4-dev-4.3.10-10ubuntu4.6
');
}

if (w) { security_hole(port: 0, data: desc); }
