# This script was automatically generated from the 349-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "gzip" is missing a security patch.

Description :

Tavis Ormandy discovered that gzip did not sufficiently verify the
validity of gzip or compress archives while unpacking. By tricking an
user or automated system into unpacking a specially crafted compressed
file, this could be exploited to execute arbitrary code with the
user\'s privileges.

Solution :

Upgrade to : 
- gzip-1.3.5-12ubuntu0.1 (Ubuntu 6.06)



Risk factor : High
';

if (description) {
script_id(27929);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "349-1");
script_summary(english:"gzip vulnerabilities");
script_name(english:"USN349-1 : gzip vulnerabilities");
script_cve_id("CVE-2006-4334","CVE-2006-4335","CVE-2006-4336","CVE-2006-4337","CVE-2006-4338");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.06", pkgname: "gzip", pkgver: "1.3.5-12ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gzip-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to gzip-1.3.5-12ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
