# This script was automatically generated from the 370-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "screen" is missing a security patch.

Description :

cstone and Rich Felker discovered a programming error in the UTF8 string 
handling code of "screen" leading to a denial of service.  If a crafted 
string was displayed within a screen session, screen would crash or 
possibly execute arbitrary code.

Solution :

Upgrade to : 
- screen-4.0.2-4.1ubuntu5.6.10 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(27951);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "370-1");
script_summary(english:"screen vulnerability");
script_name(english:"USN370-1 : screen vulnerability");
script_cve_id("CVE-2006-4573");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "screen", pkgver: "4.0.2-4.1ubuntu5.6.10");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package screen-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to screen-4.0.2-4.1ubuntu5.6.10
');
}

if (w) { security_hole(port: 0, data: desc); }
