# This script was automatically generated from the 378-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- librpm-dev 
- librpm4 
- lsb-rpm 
- python-rpm 
- python2.4-rpm 
- rpm 


Description :

An error was found in the RPM library\'s handling of query reports.  In 
some locales, certain RPM packages would cause the library to crash.  If 
a user was tricked into querying a specially crafted RPM package, the 
flaw could be exploited to execute arbitrary code with the user\'s 
privileges.

Solution :

Upgrade to : 
- librpm-dev-4.4.1-9.1ubuntu0.1 (Ubuntu 6.10)
- librpm4-4.4.1-9.1ubuntu0.1 (Ubuntu 6.10)
- lsb-rpm-4.4.1-9.1ubuntu0.1 (Ubuntu 6.10)
- python-rpm-4.4.1-9.1ubuntu0.1 (Ubuntu 6.10)
- python2.4-rpm-4.4.1-5ubuntu2.1 (Ubuntu 6.06)
- rpm-4.4.1-9.1ubuntu0.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(27960);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "378-1");
script_summary(english:"RPM vulnerability");
script_name(english:"USN378-1 : RPM vulnerability");
script_cve_id("CVE-2006-5466");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "librpm-dev", pkgver: "4.4.1-9.1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package librpm-dev-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to librpm-dev-4.4.1-9.1ubuntu0.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "librpm4", pkgver: "4.4.1-9.1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package librpm4-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to librpm4-4.4.1-9.1ubuntu0.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "lsb-rpm", pkgver: "4.4.1-9.1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package lsb-rpm-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to lsb-rpm-4.4.1-9.1ubuntu0.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "python-rpm", pkgver: "4.4.1-9.1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package python-rpm-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to python-rpm-4.4.1-9.1ubuntu0.1
');
}
found = ubuntu_check(osver: "6.06", pkgname: "python2.4-rpm", pkgver: "4.4.1-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package python2.4-rpm-',found,' is vulnerable in Ubuntu 6.06
Upgrade it to python2.4-rpm-4.4.1-5ubuntu2.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "rpm", pkgver: "4.4.1-9.1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package rpm-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to rpm-4.4.1-9.1ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
