# This script was automatically generated from the 387-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- dovecot-common 
- dovecot-imapd 
- dovecot-pop3d 


Description :

Dovecot was discovered to have an error when handling its index cache 
files.  This error could be exploited by authenticated POP and IMAP 
users to cause a crash of the Dovecot server, or possibly to execute 
arbitrary code.  Only servers using the non-default option 
"mmap_disable=yes" were vulnerable.

Solution :

Upgrade to : 
- dovecot-common-1.0.beta3-3ubuntu5.4 (Ubuntu 6.10)
- dovecot-imapd-1.0.beta3-3ubuntu5.4 (Ubuntu 6.10)
- dovecot-pop3d-1.0.beta3-3ubuntu5.4 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(27970);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "387-1");
script_summary(english:"Dovecot vulnerability");
script_name(english:"USN387-1 : Dovecot vulnerability");
script_cve_id("CVE-2006-5973");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "dovecot-common", pkgver: "1.0.beta3-3ubuntu5.4");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dovecot-common-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to dovecot-common-1.0.beta3-3ubuntu5.4
');
}
found = ubuntu_check(osver: "6.10", pkgname: "dovecot-imapd", pkgver: "1.0.beta3-3ubuntu5.4");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dovecot-imapd-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to dovecot-imapd-1.0.beta3-3ubuntu5.4
');
}
found = ubuntu_check(osver: "6.10", pkgname: "dovecot-pop3d", pkgver: "1.0.beta3-3ubuntu5.4");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package dovecot-pop3d-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to dovecot-pop3d-1.0.beta3-3ubuntu5.4
');
}

if (w) { security_hole(port: 0, data: desc); }
