# This script was automatically generated from the 389-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "gnupg" is missing a security patch.

Description :

A buffer overflow was discovered in GnuPG.  By tricking a user into 
running gpg interactively on a specially crafted message, an attacker 
could execute arbitrary code with the user\'s privileges.  This 
vulnerability is not exposed when running gpg in batch mode.

Solution :

Upgrade to : 
- gnupg-1.4.3-2ubuntu3.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(27972);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "389-1");
script_summary(english:"GnuPG vulnerability");
script_name(english:"USN389-1 : GnuPG vulnerability");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "gnupg", pkgver: "1.4.3-2ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gnupg-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to gnupg-1.4.3-2ubuntu3.1
');
}

if (w) { security_hole(port: 0, data: desc); }
