# This script was automatically generated from the 390-3 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "evince-gtk" is missing a security patch.

Description :

USN-390-2 fixed vulnerabilities in evince.  This update provides the 
corresponding update for evince-gtk.

Original advisory details:

  A buffer overflow was discovered in the PostScript processor included 
  in evince.  By tricking a user into opening a specially crafted PS 
  file, an attacker could crash evince or execute arbitrary code with 
  the user\'s privileges.

Solution :

Upgrade to : 
- evince-gtk-0.5.2-0ubuntu4.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(27975);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "390-3");
script_summary(english:"evince-gtk vulnerability");
script_name(english:"USN390-3 : evince-gtk vulnerability");
script_cve_id("CVE-2006-5864");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "evince-gtk", pkgver: "0.5.2-0ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package evince-gtk-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to evince-gtk-0.5.2-0ubuntu4.1
');
}

if (w) { security_hole(port: 0, data: desc); }
